## Setup
In this section we detail how to prepare the dataset and the environment for training and exploiting our model.

### Environment 
Our code has been tested on:
- Linux (Debian)
- Python 3.11.5
- Pytorch 2.0.1
- CUDA 11.8
- `L4` and `A100` NVIDIA GPUs


You can use Anaconda to create the environment:
```
conda create --name sig -y python=3.11.5
conda activate sig
```
Then, you can install pytorch with Cuda 11.8 using the following command:
```
pip install torch==2.0.1 torchvision==0.15.2 torchaudio==2.0.2 --index-url https://download.pytorch.org/whl/cu118 --upgrade
```
_You may have to adapt the cuda version according to your hardware, we recommend using CUDA >= 11.8_

To install the remaining requirements, execute:
```
pip install -r requirements.txt
```

### Dataset

First, set where to save the dataset by exporting the DATA_DIR variable as an environment variable:

```
export DATA_DIR=path/for/data/directory
```

Then, download the renderings of the car category of [ShapeNet](https://shapenet.org/) (data is hosted by the authors of [Scene Representation Networks](https://www.vincentsitzmann.com/srns/)):


```
cd datasets/scripts
python run_me.py 
```


## Usage
You can now efficiently learn many scenes on the shapenet car using:
```
bash train.sh train/train.yaml
bash exploit.sh exploit/exploit.yaml
```

Then, you can learn new scenes in the latent space of AE using:
```
python exploit.py --config exploit.yaml
```
## Visualization / evaluation
We visualize and evaluate our method using [wandb](https://wandb.ai/site). You can get quickstarted [here](https://docs.wandb.ai/quickstart).

